using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectDirectedUnits
	/// </summary>
	public class DlgSelectDirectedUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region variables
		

		/// <summary>
		/// CR 2043
		/// Array to keep track of any locks that are created for when the user hits Cancel 
		/// Needed since this form and FrmSelectUnitsForPatient are both setting locks for the same UC.
		/// </summary>
		private System.Collections.ArrayList _lockGuids = new ArrayList();

		// Holds records used to populate both ListViews as well as Details, Restricted, and Assigned tabs
		private DataTable _dtUnits;
		//
		private DataTable _dtSelectedUnits;
		//
		private Guid _patientGUID;
		//
		private bool _validateUnitsChosenCorrectly;
		// for UC16
		private DataTable _dtAutoDirUnits;
		private DataTable _dtAssignCrossUnits;

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodBagLabel1;
		private System.Windows.Forms.GroupBox grpImage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpSelectedUnit;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
        private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ListView lvAssignedUnits;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ListView lvAutologousUnits;
		private System.Windows.Forms.TabControl tabUnits;
		private System.Windows.Forms.TabPage pageAutologous;
		private System.Windows.Forms.TabPage pageAssigned;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectDirectedUnits()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC003SelectUnitsForPatient;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
		}

		/// <summary>
		/// Constructor
		/// used by UC16 to find all directed units
		/// </summary>
		/// <param name="patientGuid"></param>
		public DlgSelectDirectedUnits(Guid patientGuid)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

            this.SetupComponents();

            this.btnOK.Visible = false;
			this.btnCancel.Text = "&Close";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");

			_patientGUID = patientGuid;
			this.btnOK.EnabledButton = true;

			this.patientDisplayPanel1.Patient = new BOL.Patient(_patientGUID);
			// When coming from UC16, this display is for informational purposes.  Everything should be read only! 
			this.lvAutologousUnits.CheckBoxes = false;
			this.lvAssignedUnits.CheckBoxes = false;
			_dtAutoDirUnits = BOL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid);
			_dtAssignCrossUnits = BOL.OrderedUnit.GetOrderedUnitsForPatient(patientGuid);
			LoadADTab(_dtAutoDirUnits);
			LoadACTab(_dtAssignCrossUnits);

			this.lvAutologousUnits.CheckBoxes = false;
			this.lvAssignedUnits.CheckBoxes = false;
			
		}

		/// <summary>
		/// Constructor
		/// used by UC3 to select units and display those previously selected
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <param name="dtUnits"></param>
		public DlgSelectDirectedUnits(Guid patientGuid, DataTable dtUnits)
		{
            // This call is required by the Windows Form Designer.
            InitializeComponent();


            this.SetupComponents();
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);

			_patientGUID = patientGuid;
			this.patientDisplayPanel1.Patient = new BOL.Patient(this._patientGUID);
			this.lvAutologousUnits.Columns.Add("Donation Type", 120, HorizontalAlignment.Left);

			_dtAssignCrossUnits = BOL.OrderedUnit.GetOrderedUnitsForPatient(patientGuid);
			
			_dtUnits = dtUnits;
			_dtSelectedUnits = dtUnits.Copy();
		
			LoadADTab(_dtUnits);
			if (_dtAssignCrossUnits.Rows.Count > 0) 
			{
				this.lvAssignedUnits.Enabled = true;
				this.lvAssignedUnits.CheckBoxes = false;
				LoadACTab(this._dtAssignCrossUnits);
			}
			else
			{
				this.lvAssignedUnits.Enabled = false;
			}
		}

		#endregion


		#region properties

		/// <summary>
		/// Get Units
		/// </summary>
		public DataTable Units
		{
			get
			{
				return _dtUnits;
			}
		}

		/// <summary>
		/// Get SelectedUnits
		/// </summary>
		public DataTable SelectedUnits
		{
			get
			{
				return _dtSelectedUnits;
			}
		}

		/// <summary>
		/// Get/Set ValidateUnitsChosenCorrectly
		/// used for BR_3.34
		/// </summary>
		public bool ValidateUnitsChosenCorrectly
		{
			get
			{
				return _validateUnitsChosenCorrectly;
			}
			set
			{
				_validateUnitsChosenCorrectly = value;
			}
		}

		#endregion


		#region methods

        /// <summary>
        /// Added for code-sharing with multiple constructors
        /// </summary>
        private void SetupComponents()
        {
            this.LockController.LockFunction = Common.LockFunctions.UC003SelectUnitsForPatient;

            // CR 2693
            // hlpHelp
            this.hlpHelp.HelpNamespace = Environment.CurrentDirectory + "\\VBECS.chm";

            // hlphelpChm
            this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory + "\\VBECS.chm";

            this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC003.DlgSelectDirectedUnits());

        }
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgSelectDirectedUnits));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lvAutologousUnits = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpSelectedUnit = new System.Windows.Forms.GroupBox();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.bloodBagLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
            this.lvAssignedUnits = new System.Windows.Forms.ListView();
            this.columnHeader10 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.tabUnits = new System.Windows.Forms.TabControl();
            this.pageAutologous = new System.Windows.Forms.TabPage();
            this.pageAssigned = new System.Windows.Forms.TabPage();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSelectedUnit.SuspendLayout();
            this.tabUnits.SuspendLayout();
            this.pageAutologous.SuspendLayout();
            this.pageAssigned.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(736, 30);
            this.vbecsLogo1.TabIndex = 5;
            this.vbecsLogo1.Title = "Available Restricted or Assigned Units";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 475);
            this.lblRequiredField.TabIndex = 7;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 72);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 388);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 36);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(658, 464);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(578, 464);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 3;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // lvAutologousUnits
            // 
            this.lvAutologousUnits.AccessibleDescription = "Restricted Units";
            this.lvAutologousUnits.AccessibleName = "Restricted Units";
            this.lvAutologousUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAutologousUnits.CheckBoxes = true;
            this.lvAutologousUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5});
            this.lvAutologousUnits.FullRowSelect = true;
            this.lvAutologousUnits.Location = new System.Drawing.Point(4, 4);
            this.lvAutologousUnits.MultiSelect = false;
            this.lvAutologousUnits.Name = "lvAutologousUnits";
            this.lvAutologousUnits.Size = new System.Drawing.Size(392, 348);
            this.lvAutologousUnits.TabIndex = 0;
            this.lvAutologousUnits.UseCompatibleStateImageBehavior = false;
            this.lvAutologousUnits.View = System.Windows.Forms.View.Details;
            this.lvAutologousUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvAutologousUnits_ItemCheck);
            this.lvAutologousUnits.SelectedIndexChanged += new System.EventHandler(this.SelectedIndexChanged);
            this.lvAutologousUnits.MouseMove += new System.Windows.Forms.MouseEventHandler(this.lvAutologousUnits_MouseMove);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 25;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            this.columnHeader2.Width = 100;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            this.columnHeader3.Width = 80;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            this.columnHeader4.Width = 80;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expiration Date";
            this.columnHeader5.Width = 100;
            // 
            // grpSelectedUnit
            // 
            this.grpSelectedUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectedUnit.Controls.Add(this.bloodUnitDetailsTab1);
            this.grpSelectedUnit.Controls.Add(this.bloodBagLabel1);
            this.grpSelectedUnit.Location = new System.Drawing.Point(462, 76);
            this.grpSelectedUnit.Name = "grpSelectedUnit";
            this.grpSelectedUnit.Size = new System.Drawing.Size(272, 384);
            this.grpSelectedUnit.TabIndex = 2;
            this.grpSelectedUnit.TabStop = false;
            this.grpSelectedUnit.Text = "Selected Unit Details";
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(8, 224);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(256, 152);
            this.bloodUnitDetailsTab1.TabIndex = 2;
            // 
            // bloodBagLabel1
            // 
            this.bloodBagLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
            this.bloodBagLabel1.BloodUnit = null;
            this.bloodBagLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodBagLabel1.Location = new System.Drawing.Point(8, 16);
            this.bloodBagLabel1.Name = "bloodBagLabel1";
            this.bloodBagLabel1.Size = new System.Drawing.Size(257, 204);
            this.bloodBagLabel1.TabIndex = 0;
            this.bloodBagLabel1.TabStop = false;
            // 
            // lvAssignedUnits
            // 
            this.lvAssignedUnits.AccessibleDescription = "Crossmatched/Assigned Units";
            this.lvAssignedUnits.AccessibleName = "Crossmatched/Assigned Units";
            this.lvAssignedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAssignedUnits.CheckBoxes = true;
            this.lvAssignedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader10,
            this.columnHeader11,
            this.columnHeader12,
            this.columnHeader13,
            this.columnHeader14});
            this.lvAssignedUnits.FullRowSelect = true;
            this.lvAssignedUnits.Location = new System.Drawing.Point(4, 4);
            this.lvAssignedUnits.MultiSelect = false;
            this.lvAssignedUnits.Name = "lvAssignedUnits";
            this.lvAssignedUnits.Size = new System.Drawing.Size(392, 348);
            this.lvAssignedUnits.TabIndex = 0;
            this.lvAssignedUnits.UseCompatibleStateImageBehavior = false;
            this.lvAssignedUnits.View = System.Windows.Forms.View.Details;
            this.lvAssignedUnits.SelectedIndexChanged += new System.EventHandler(this.SelectedIndexChanged);
            // 
            // columnHeader10
            // 
            this.columnHeader10.Text = "";
            this.columnHeader10.Width = 25;
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Unit ID";
            this.columnHeader11.Width = 100;
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "Product";
            this.columnHeader12.Width = 80;
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "ABO/Rh";
            this.columnHeader13.Width = 80;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Expiration Date";
            this.columnHeader14.Width = 100;
            // 
            // tabUnits
            // 
            this.tabUnits.AccessibleDescription = "Available Restricted or Assigned Units";
            this.tabUnits.AccessibleName = "Available Restricted or Assigned Units";
            this.tabUnits.Controls.Add(this.pageAutologous);
            this.tabUnits.Controls.Add(this.pageAssigned);
            this.tabUnits.Location = new System.Drawing.Point(48, 76);
            this.tabUnits.Name = "tabUnits";
            this.tabUnits.SelectedIndex = 0;
            this.tabUnits.Size = new System.Drawing.Size(408, 384);
            this.tabUnits.TabIndex = 1;
            // 
            // pageAutologous
            // 
            this.pageAutologous.Controls.Add(this.lvAutologousUnits);
            this.pageAutologous.Location = new System.Drawing.Point(4, 23);
            this.pageAutologous.Name = "pageAutologous";
            this.pageAutologous.Size = new System.Drawing.Size(400, 357);
            this.pageAutologous.TabIndex = 0;
            this.pageAutologous.Text = "Restricted Units";
            // 
            // pageAssigned
            // 
            this.pageAssigned.Controls.Add(this.lvAssignedUnits);
            this.pageAssigned.Location = new System.Drawing.Point(4, 23);
            this.pageAssigned.Name = "pageAssigned";
            this.pageAssigned.Size = new System.Drawing.Size(400, 357);
            this.pageAssigned.TabIndex = 1;
            this.pageAssigned.Text = "Crossmatched/Assigned Units";
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 32);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(732, 44);
            this.patientDisplayPanel1.TabIndex = 8;
            // 
            // DlgSelectDirectedUnits
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(736, 489);
            this.Controls.Add(this.patientDisplayPanel1);
            this.Controls.Add(this.tabUnits);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpSelectedUnit);
            this.hlphelpChm.SetHelpKeyword(this, "Select_Units.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(628, 516);
            this.Name = "DlgSelectDirectedUnits";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Available Restricted or Assigned Units";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectDirectedUnits_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.grpSelectedUnit, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.tabUnits, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.patientDisplayPanel1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSelectedUnit.ResumeLayout(false);
            this.tabUnits.ResumeLayout(false);
            this.pageAutologous.ResumeLayout(false);
            this.pageAssigned.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void LoadADTab(DataTable dtUnits)
		{
			foreach (System.Data.DataRow dr in dtUnits.Rows)
			{
				int donationTypeID = (int) dr[Common.VbecsTables.DonationType.DonationTypeId];

				// BR_16.12
				ListViewItem lVI = new ListViewItem();
				if (dr[Common.VbecsTables.BloodUnit.DivisionCode].ToString().Trim() != Common.LogonUser.LogonUserDivisionCode)
				{
					lVI.ForeColor = System.Drawing.Color.FromKnownColor(KnownColor.GrayText);
				}
				lVI.SubItems.Add(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString());
				lVI.SubItems.Add(dr[Common.VbecsTables.BloodProduct.ProductShortName].ToString());
				lVI.SubItems.Add(dr[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString());
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate]));
				lVI.Tag = dr;

				Common.UnitStatusCode statusCode = Common.Utility.GetUnitStatusCodeFromString(
													dr[Common.VbecsTables.BloodUnit.UnitProductCode].ToString());

				this.lvAutologousUnits.Items.Add(lVI);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvAutologousUnits);
		}

		private void LoadACTab(DataTable dtUnits)
		{
			foreach (System.Data.DataRow dr in dtUnits.Rows)
			{				
				// BR_16.12
				ListViewItem lVI = new ListViewItem();
				if (lvAssignedUnits.CheckBoxes == true)
				{
					lVI.SubItems.Add(String.Empty);
				}
				lVI.SubItems.Add(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString());
				lVI.SubItems.Add(dr[Common.VbecsTables.BloodProduct.ProductShortName].ToString());
				lVI.SubItems.Add(dr[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString());
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate]));
				lVI.Tag = dr;

				Common.UnitStatusCode statusCode = Common.Utility.GetUnitStatusCodeFromString(
					dr[Common.VbecsTables.BloodUnit.UnitProductCode].ToString());
				//
				this.lvAssignedUnits.Items.Add(lVI);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvAssignedUnits);
		}

		private bool ValidUnitsChosen()
		{
			bool autologousUnitsUnchecked = false;
			bool directedUnitsUnchecked = false;
			bool directedUnitsChecked = false;
			bool allogeneicUnitsChecked = false;
		
			bool validUnits = true;

			foreach (ListViewItem lVI in this.lvAutologousUnits.Items)
			{
				// A cast of a cast!  Gasp!
				int donationTypeID = (int) ((DataRow) lVI.Tag)[Common.VbecsTables.DonationType.DonationTypeId];

				switch (donationTypeID)
				{
					// allogeneic units
					case (int) Common.DonationTypeId.VolunteerAllogeneicDonor:
						if (lVI.Checked == true)  allogeneicUnitsChecked = true;
						break;
					//autologous units
					case (int) Common.DonationTypeId.AutologousEligibleForCrossover:
						if (lVI.Checked == false) autologousUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForAutologousUseOnly:
						if (lVI.Checked == false) autologousUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForAutologousUseOnlyBiohazardous:
						if (lVI.Checked == false) autologousUnitsUnchecked = true;
						break;
					// directed units
					case (int) Common.DonationTypeId.VolunteerDirectedEligibeForCrossover:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.PaidDirectedEligibleForCrossover:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForDirectedDonorUseOnly:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForDirectedDonorUseOnlyLimitedExposure:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForDirectedDonorUseOnlyMedicalException:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.ForDirectedDonorUseOnlyBiohazardous:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.DesignatedDonor:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					case (int) Common.DonationTypeId.DedicatedDonor:
						if (directedUnitsChecked == true) directedUnitsChecked = true;
						directedUnitsUnchecked = true;
						break;
					default:
						break;
				}
			}

			//BR_3.34
			if ( (directedUnitsChecked == true && autologousUnitsUnchecked == true) ||
				(allogeneicUnitsChecked == true && (autologousUnitsUnchecked == true || directedUnitsUnchecked == true)) )
			{
				validUnits = false;
			}
			return validUnits;														  
		}

		#endregion


		#region events

		private void SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ( ((ListView) sender).SelectedIndices.Count > 0 )
			{
				ListView lV = (ListView) sender;
				ListViewItem lVI = lV.SelectedItems[0];
				DataRow dr = (DataRow) lVI.Tag;
								
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit(dr);
				this.bloodBagLabel1.BloodUnit = bloodUnit;
				this.bloodUnitDetailsTab1.BloodUnit = bloodUnit;
			}
		}

		private void lvAutologousUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			//CR2043 - Added locking code to ItemCheck event for BloodUnitStatus 
			ListView lv = (ListView) sender;
			ListViewItem lVI = lv.Items[e.Index];
			DataRow dtRow = (DataRow) lVI.Tag;
			System.Guid busGuid = (System.Guid)dtRow[Common.VbecsTables.BloodUnitStatus.BloodUnitStatusGuid];

			if ( ((e.NewValue == CheckState.Checked)&&(e.CurrentValue == CheckState.Unchecked)) ||
				this.lvAutologousUnits.CheckedItems.Count > 1) 
			{
				//only units in the current division are selectable
				if (dtRow[Common.VbecsTables.BloodUnit.DivisionCode].ToString().Trim() != Common.LogonUser.LogonUserDivisionCode)
				{
					e.NewValue = CheckState.Unchecked;
				}
				else
				{
					//Take care of the locking
					if (e.NewValue == CheckState.Checked)
					{
						if (this.SetLocks(busGuid))		//Checking the item, and locking passes, proceed as normal
						{
							this._lockGuids.Add(busGuid);
							this.btnOK.EnabledButton = true;
							this.btnOK.SetToolTip(String.Empty);
						}
						else
						{
							e.NewValue = CheckState.Unchecked;	//Locking failed, don't check box
							//Checking item, but locking failed - set btnOk accordingly
							if (this.lvAssignedUnits.CheckedItems.Count > 0)
							{
								//If we have stuff checked already, set/leave OK button enabled
								this.btnOK.Enabled = true;
								this.btnOK.SetToolTip(String.Empty);
							}
						}
					}
					else
					{	//User is unchecking 1 of many checked items
						this.ReleaseLocks(busGuid);
					}
				}
			}
			else
			{
				this.ReleaseLocks(busGuid);
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);
			}					  
		}


		private void btnOK_Click(object sender, System.EventArgs e)
		{		
			foreach (ListViewItem lVI in this.lvAutologousUnits.Items)
			{
				DataRow dr = (DataRow) lVI.Tag;
				Guid bloodUnitGUID = (Guid) dr[Common.VbecsTables.BloodUnit.BloodUnitGuid];
				DataRow [] drArray = this._dtSelectedUnits.Select(Common.VbecsTables.BloodUnit.BloodUnitGuid +
																	" = '" + bloodUnitGUID + "'");
				// If not checked, remove from DataTable and set flag to indicate there are still units available
				if (!lVI.Checked)
				{
					this._dtSelectedUnits.Rows.Remove( (DataRow) drArray[0] );
				}
			}
			this.Close();
		}
		
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();		
		}

		/// <summary>
		/// CR2043 - Since they're cancelling - release all the locks - even if we don't have an item checked anymore, this will pass
		///	Form_Close unlocking is being bypassed because of the locking sharing with the parent form
		///	This method is made public so the parent form can call it if the user clicks the ControlBox "X" - which isn't trapped in the btn_Cancel event
		/// </summary>
		public void CancelLocks()
		{
			this.ReleaseLocks((System.Guid[])_lockGuids.ToArray(typeof(System.Guid)));
		}
		
		private void lvAutologousUnits_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ListViewItem lVI = this.lvAutologousUnits.GetItemAt(e.X,e.Y);
					
			if ( lVI != null )
			{
				string divisionCode = (string) ((DataRow) lVI.Tag)["DivisionCode"];

                //CR 3282 Setting tooltip on listview item instead of a listview
                this.lvAutologousUnits.ShowItemToolTips = true;
				if (divisionCode.Trim() != Common.LogonUser.LogonUserDivisionCode)
				{
					lVI.ToolTipText = Common.StrRes.InfoMsg.UC003.IncorrectDivision(divisionCode).ResString;
				}
				else
				{
					lVI.ToolTipText = string.Empty;
				}
			} 
		}	

		/// <summary>
		/// DlgSelectDirectedUnits_KeyDownSpeakMessage Event Handler
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectDirectedUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = this.patientDisplayPanel1.GetErrorMessagesFor508();
			}
			textToSpeak = string.Concat(textToSpeak, this.bloodUnitDetailsTab1.GetErrorMessages());
			textToSpeak = string.Concat(textToSpeak, this.btnOK.GetToolTip());
			
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}
			this.SpeakMessage( textToSpeak );
		}

		#endregion

	}
}

